d3.csv('dataWrangling/characterWinLossChord.csv', function (error, data) {
var mpr = chordMpr(data);

mpr.addValuesToMap('winner')
  .setFilter(function (row, b, a) {
    return (row.winner === a.name && row.loser === b.name)
  })
  .setAccessor(function (recs, b, a) {
    if (!recs[0]) return 0;
    return +recs[0].count;
  });
  matrix = mpr.getMatrix();
  map = mpr.getMap();

  var width = 1000;
  var height = 800;
  var outerRadius = height / 2;
  var innerRadius = outerRadius - 100;

// .range([abel,adon,akuma, c viper, chun-li, decapre,dhalsim,
//    elena, evil ryu, fei long, gen, guile, hugo, ken,
//    '#e72955', '#83bf02', makoto, poison, rolento, rose, sagat, sakura,
//    seth, yang, yun, zangief]);

  var fill = d3.scale.ordinal()
    .range(['#75ff6c', '#0a72ff', '#8ffec2', '#a8879f', '#ecffa7', '#e72955',
      '#ff9569', '#3f8670', '#ff1902', '#b85f60', '#7570c1', '#83bf02',
      '#16be61', '#dad045', '#fe07a6', '#f97505', '#2dfefe', '#05b3ff', 
      '#1eff06', '#e992ff', '#85bfd1', '#ffb209', '#bba67b', '#fcff04']);

  var chord = d3.layout.chord()
    .padding(.05)
    .sortSubgroups(d3.descending)
    .sortChords(d3.descending)
    .matrix(matrix);

  var arc = d3.svg.arc()
    .innerRadius(innerRadius)
    .outerRadius(innerRadius + 20);

  var svg = d3.select("body").append("svg")
    .attr("width", width)
    .attr("height", height)
    .append("g")
    .attr("id", "circle")
    .attr("transform", "translate(" + width / 2 + "," + height / 2 + ")");

    svg.append("circle").attr("r", innerRadius + 20)

  var rdr = chordRdr(matrix, map);

  var g = svg.selectAll("g.group")
            .data(chord.groups())
          .enter().append("g")
            .attr("class", "group")
            .on("mouseover", mouseover)
            .on("mouseout", mouseout);

  g.append("path")
      .style("stroke", "black")
      .style("fill", function(d) { return fill(d.index); })
      .attr("d", arc);

  g.append("text")
      .each(function(d) { d.angle = (d.startAngle + d.endAngle) / 2; })
      .attr("dy", ".35em")
      .style("font-family", "helvetica, arial, sans-serif")
      .style("font-size", "15px")
      .style("fill","white")
      .attr("text-anchor", function(d) { return d.angle > Math.PI ? "end" : null; })
      .attr("transform", function(d) {
        return "rotate(" + (d.angle * 180 / Math.PI - 90) + ")"
            + "translate(" + (innerRadius + 26) + ")"
            + (d.angle > Math.PI ? "rotate(180)" : "");
      })
      .text(function(d) { return rdr(d).gname; })
      .attr("font-size","15px");

  var chordPaths = svg.selectAll("path.chord")
        .data(chord.chords())
      .enter().append("path")
        .attr("class", "chord")
        .style("stroke", function(d) { return d3.rgb(fill(d.target.index)).darker(); })
        .style("fill", function(d) { return fill(d.target.index); })
        .attr("d", d3.svg.chord().radius(innerRadius))
        .on("mouseover", function (d) {
          d3.select("#tooltip")
            .style("visibility", "visible")
            .html(chordTip(rdr(d)))
            .style("top", function () { return (d3.event.pageY - 100)+"px"})
            .style("left", function () { return (d3.event.pageX - 100)+"px";})
        })
        .on("mouseout", mouseout);

  function chordTip (d) {
    var p = d3.format(".2%"), q = d3.format(",.3r")
    d3.select(".scatterplot").selectAll("circle")
      .transition()
      .duration(500)
      .style("fill", function(e){
        var circ = d3.select(this);
        if(circ.style('opacity') == 1)
        {
          if((d.sname != e["Opponent Character"] && d.tname != e["Opponent Character"]))
          {
            return d3.rgb(128,128,128);}
          }else{
            return color(cValue(e));
        }
        return color(cValue(e));
      });

    //ensures that loser appears first in tooltip text
    if(d.tvalue < d.svalue) {
      return "Matchup Results:<br/>"
     + d.sname + " versus " + d.tname + ": " + d.tvalue + "-" + d.svalue
    } else {
      return "Matchup Results:<br/>"
     + d.tname + " versus " + d.sname + ": " + d.svalue + "-" + d.tvalue
    }
    
  }

  function groupTip (d) {
    var p = d3.format(".1%"), q = d3.format(",.1r")
    return "Character Info:<br/>"
        + d.gname + " appeared in " + q(d.gvalue) + " matches" + "<br/>"
        + p(d.gvalue/d.mtotal) + " of total matches (" + q(d.mtotal) + ")"
  }

  function mouseover(d, i) {
    d3.select("#tooltip")
      .style("visibility", "visible")
      .html(groupTip(rdr(d)))
      .style("top", function () { return (d3.event.pageY - 80)+"px"})
      .style("left", function () { return (d3.event.pageX - 130)+"px";})

    chordPaths.classed("fade", function(p) {
      return p.source.index != i
          && p.target.index != i;
    });
  }

  function mouseout(d, i){
    d3.select("#tooltip").style("visibility", "hidden");
    d3.select(".scatterplot").selectAll("circle")
        .transition()
        .duration(500)
        .style("fill", function(e){
            return color(cValue(e));
        });
  }
});
