import csv
import pprint

def csvToDictionary(csvName):
    streetFighterData = []
    with open('../' + csvName + '.csv') as csvFile:
        reader = csv.reader(csvFile)
        fields = reader.next()
        for row in reader:
            labeledRow = zip(fields, row)
            item = {}
            for (label, data) in labeledRow:
                item[label] = data
            streetFighterData.append(item)
        return streetFighterData


streetFighterData = csvToDictionary('streetfighter')
characterMatchups = {}
for match in streetFighterData:
    playerCharacter = match['Character Played']
    opponentCharacter = match['Opponent Character']
    if not playerCharacter in characterMatchups:
        characterMatchups[playerCharacter] = {}
    if not opponentCharacter in characterMatchups[playerCharacter]:
        characterMatchups[playerCharacter][opponentCharacter] = 0
    characterMatchups[playerCharacter][opponentCharacter] += 1

data = []

playerCharacterKeys = characterMatchups.keys()
playerCharacters = []
for character in playerCharacterKeys:
    characterNoSpaces = character.strip()
    if not characterNoSpaces in playerCharacters:
        print characterNoSpaces
        playerCharacters.append(characterNoSpaces)
playerCharacters.sort()

opponentCharacters = []
for characters in characterMatchups:
    for opponentCharacter in characterMatchups[characters]:
        opponentCharacterNoSpaces = opponentCharacter.strip()
        if not opponentCharacterNoSpaces in opponentCharacters:
            opponentCharacters.append(opponentCharacterNoSpaces)
opponentCharacters.sort()

print playerCharacters
print opponentCharacters

allCharacters = list(set(playerCharacters)|set(opponentCharacters))
allCharacters.sort()

allCharacters.insert(0, '')

data.append(allCharacters)

for character in allCharacters:
    if character in characterMatchups:
        row = []
        row.append(character)
        for opponentCharacter in allCharacters:
            if opponentCharacter in characterMatchups[character]:
                matchupWins = characterMatchups[character][opponentCharacter]
                row.append(matchupWins)
            elif opponentCharacter != '':
                row.append(0)
        data.append(row)

with open('characterWinLoss.csv', 'wb') as csvWriteFile:
    writer = csv.writer(csvWriteFile)
    for row in data:
        writer.writerow(row)
