var margin = {top: 0, right: 0, bottom: 30, left: 0};
var legendWidth = 110 - margin.left - margin.right;
var legendHeight = 600 - margin.top - margin.bottom;

// var selectedManufacturer, selectedCalories = 0;
var manu = 0;
var cal = 0;

// setup fill color
var cValue = function(d) { return d["Player Character"];},
color = d3.scale.ordinal()
  .range(['#0a72ff','#1eff06','#ff1902','#2dfefe','#fe07a6','#a8879f','#fcff04',
   '#16be61', '#ff9569', '#05b3ff', '#ecffa7', '#3f8670', '#e992ff', '#ffb209',
   '#e72955', '#83bf02', '#bba67b', '#7570c1', '#85bfd1', '#f97505', '#8ffec2', '#dad045',
   '#b85f60', '#75ff6c', '#fe4df2', '#78a55a']);

//drop down list
var characters = ["--Select Focus Character--", "All Characters", "Abel", "Adon", "Akuma",
  "C. Viper", "Chun-Li", "Decapre", "Dhalsim", "Elena", "Evil Ryu", "Fei Long", "Gen", "Guile",
  "Hugo", "Ken", "Makoto", "Poison", "Rolento", "Rose", "Sagat", "Sakura", "Seth", "Yang", "Yun", "Zangief"];

var choice = d3.select('#chardrop');

var options = choice
  .selectAll('option')
    .data(characters).enter()
    .append('option')
      .text(function(d) {return d;});
choice.on('change', onchange);


function onchange() {
    var selectValue = choice.node().value;

    svg.selectAll('.dot')
      .transition()
      .duration(500)
      .style('opacity', .1)
      .filter(function (d) {
        if(selectValue == "--Select Focus Character--")
        {
          d3.select(".legend").selectAll("text").style("fill","rgb(128,128,128)")
          return false;
        }
        if(selectValue == "All Characters")
        {
          d3.select(".legend").selectAll("text").style("fill","rgb(255,255,255)")
          return true;
        }
        d3.select(".legend").selectAll("text").style("fill", function(e)
        {
          if(e == selectValue)
            return "rgb(255,255,255)";
          return "rgb(128,128,128)";
        });
        return d["Player Character"] == selectValue;
      })
      .transition()
      .duration(500)
      .style('opacity', 1);
};

// load data
d3.csv("CapcomCup2015_CombinedData.csv", function(error, rawData) {

  var data = [];

  // change string (from CSV) into number format
  rawData.forEach(function(d) {
    d["Opponent HP Remaining"] = +d["Opponent HP Remaining"];
    d["Death X"] = +d["Death X"];
    data.push(d);
  });

  data.sort(function (a,b) {return d3.ascending(a["Player Character"], b["Player Character"]);});

  plotScatter(data);

  var svg = d3.select(".legend").append("svg")
    .attr("width", legendWidth + margin.left + margin.right)
    .attr("height", legendHeight + margin.top + margin.bottom);

  // draw legend
  var legend = svg.selectAll(".legend")
    .data(color.domain())
  .enter().append("g")
    .attr("class", "legend")
    .attr("transform", function(d, i) { return "translate(0," + i * 25 + ")"; });

  // draw legend colored rectangles
  legend.append("rect")
    .attr("x", 18)
    .attr("width", 18)
    .attr("height", 18)
    .style("fill", color);

  // draw legend text
  var legText = legend.append("text")
    .attr("x", 40)
    .attr("y", 9)
    .attr("dy", ".35em")
    .attr("fill", "rgb(128,128,128)")
    .attr("font-size", "15px")
    .text(function(d) { return d;});

    var textLeg = d3.select(".legend").selectAll("text")
    .on("mouseover", function(d){
      //Feedback on mouse over to imply interaction functionality
      if(textLeg.style("fill")=="rgb(255,255,255)")
        d3.select(this).style("fill", 'yellow');
    })
    .on("mouseout", function(d){
      //Feedback on mouse out to imply interaction functionality
      if(textLeg.style("fill")=="rgb(255,255,255)")
        d3.select(this).style("fill", 'white');
    })
    .on("click", function(d){
      //Feedback
      d3.select(this).style("fill", d3.rgb(128,128,128));
      //Negative version of filter functionality (benefits insight control)
      legName = d3.select(this).text();
      d3.select(".scatterplot").selectAll(".dot").style("opacity", function(e)
      {
        var legNamet = legName;
        var originalOpac = d3.select(this);
        if(e["Player Character"]== legName)
        {
          return 0.1;
        }else return originalOpac.style('opacity');
      })
    });


});
