var margin = {top: 10, right: 30, bottom: 30, left: 50};
var width = 600 - margin.left - margin.right;
var height = 600 - margin.top - margin.bottom;

// pre-cursors
var sizeForCircle = function(d) {
  return 6 * (d["Time Remaining"]/45);
}

// setup x
var xValue = function(d) { return d["Death X"];}, // data -> value
    xScale = d3.scale.linear().range([0, width]), // value -> display
    xMap = function(d) { return xScale(xValue(d));}, // data -> display
    xAxis = d3.svg.axis().scale(xScale).orient("bottom");

// setup y
var yValue = function(d) { return d["Opponent HP Remaining"];}, // data -> value
    yScale = d3.scale.linear().range([height, 0]), // value -> display
    yMap = function(d) { return yScale(yValue(d));}, // data -> display
    yAxis = d3.svg.axis().scale(yScale).orient("right");

// add the graph canvas to the body of the webpage
var svg = d3.select(".scatterplot").append("svg")
    .attr("width", width + margin.left + margin.right)
    .attr("height", height + margin.top + margin.bottom)
    .append("g")
    .attr("transform", "translate(" + margin.left + "," + margin.top + ")");

// add the tooltip area to the webpage
var tooltip = d3.select("body").append("div")
    .attr("class", "tooltip")
    .style("opacity", 0);

// display the scatter plot
function plotScatter(data) {

  // don't want dots overlapping axis, so add in buffer to data domain
  xScale.domain([d3.min(data, xValue)-.1, d3.max(data, xValue)+.1]);
  yScale.domain([d3.min(data, yValue)-.1, d3.max(data, yValue)+.1]);

  // x-axis
  svg.append("g")
      .attr("class", "x axis")
      .attr("transform", "translate(0," + height + ")")
      .attr("fill", "white")
      .call(xAxis)
    .append("text")
      .attr("class", "label")
      .attr("x", width)
      .attr("y", -6)
      .attr("fill", "white")
      .style("text-anchor", "end")
      .text("Death Coordinate")
      .attr("font-size","13px");

  // y-axis
  svg.append("g")
      .attr("class", "y axis")
      .attr("fill", "white")
      .call(yAxis)
    .append("text")
      .attr("class", "label")
      .attr("transform", "rotate(-90)")
      .attr("y", -15)
      .attr("dy", ".71em")
      .attr("fill", "white")
      .style("text-anchor", "end")
      .text("Opponent HP Remaining (%)")
      .attr("font-size","13px");


  // draw dots
  svg.selectAll(".dot")
      .data(data)
    .enter().append("circle")
      .attr("class", "dot")
      .attr("r", sizeForCircle)
      .attr("cx", xMap)
      .attr("cy", yMap)
      .style("fill", function(d) { return color(cValue(d));})
      .style("opacity", .1)
      .on("click", function(d) {
          // for onclick functionality later
      })
      .on("mouseover", function(d) {
          // for mouseover

          //makes tooltip visible
          tooltip.transition()
              .duration(200)
              .style("opacity", 1);

          //information in tool tip
          tooltip.html("<strong>Vs</strong>: " + d["Opponent Character"] +
            "<br/><strong>Kill Button: </strong>"+ d["Killed by Button"] +
            "<br/><strong>Kill Condition: </strong>" + d["Death Type"])
              .style("left", (d3.event.pageX + 5) + "px")
              .style("top", (d3.event.pageY - 28) + "px");

          // expands circle
          var circle = d3.select(this);
          circle.transition()
            .duration(1200)
            .attr("r", 16).ease("elastic")
      })
      .on("mouseout", function(d) {
          // for mouseout functionality

          //makes tooltip invisible
          tooltip.transition()
             .duration(500)
             .style("opacity", 0);

          var circle = d3.select(this);

          circle.transition()
              .duration(1200)
              .attr('r', sizeForCircle).ease('elastic');
      });
}
