var height = 600;
var width = 600;
var cutoff = 0; //Used to hide death types which did not occur frequently
var data = [];

//Code based off jsfiddle found here http://jsfiddle.net/dY372/
function getRoundFilters() {
    var checkboxes = document.querySelectorAll('input[name="round"]:checked'), values = [];
    Array.prototype.forEach.call(checkboxes, function(el) {
        values.push(el.value);
    });

    if(values.length == 0){
        values.push('Overall');
    }
    return values;
}

function getNormalizeFilter() {
    var checkbox = document.getElementById('normalize');
    return checkbox.checked;
}

function drawStarPlot(){
    d3.selectAll("svg > *").remove();
    data = [];
    d3.csv("CapcomCup2015_CombinedData.csv", function(error, rawData) {
        var deathTypes = [];
        var roundData = [];
        roundData['Overall'] = [];
        roundData['Overall']['Count'] = 0;
        var deathCount = [];
        var legendLabels = [];

        rawData.forEach(function(d){
            if(typeof roundData[d['Bracket']] === 'undefined'){
                roundData[d['Bracket']] = [];
                roundData[d['Bracket']]['Count'] = 0;
            }

            if(typeof roundData[d['Bracket']][d['Death Type']] === 'undefined')
            {
                roundData[d['Bracket']][d['Death Type']] = 0;
            }
            roundData[d['Bracket']][d['Death Type']] += 1;
            roundData[d['Bracket']]['Count'] += 1;

            if(typeof roundData['Overall'][d['Death Type']] === 'undefined')
            {
                roundData['Overall'][d['Death Type']] = 0;
            }

            roundData['Overall'][d['Death Type']] += 1;
            roundData['Overall']['Count'] += 1;
        });

        var selectedFilters = getRoundFilters();
        var normalizeData = getNormalizeFilter();

        var maxVal = [];
        var maxValInt = 0;

        function initAllToZero(){
            var arr = [];
            var deathTypes = roundData['Overall'];

            for(var deathType in deathTypes){
                if(deathType !== 'Count'){
                    arr.push({
                        axis: deathType,
                        value: 0
                    });
                }
            }
            return arr;
        }

        function setDeathTypeToValue(arr, dt, val){
            var deathTypes = roundData['Overall'];

            for(var i = 0; i < arr.length; i++){
                if(arr[i].axis === dt){
                    arr[i].value = val;
                }
            }
        }

        for(var round in roundData){
            var dat = [];
            var deathTypes = roundData[round];
            var roundCount = deathTypes['Count'];
            maxVal[round] = 0;

            dat = initAllToZero();

            for(var deathType in deathTypes){
                if(deathType !== 'Count'){
                    if(deathTypes[deathType] > cutoff){
                        var deathTypeVal = deathTypes[deathType];
                        if(normalizeData){
                            deathTypeVal = deathTypeVal / roundCount; 
                        }

                        if(deathTypeVal > maxVal[round]){
                            maxVal[round] = deathTypeVal;
                        }

                        setDeathTypeToValue(dat, deathType, deathTypeVal);
                    }
                }
            }

            for(var i = 0; i < selectedFilters.length; i++){
                if(selectedFilters[i] === round){
                    if(maxValInt < maxVal[round]){
                        maxValInt = maxVal[round];
                    }
                    data.push(dat);
                    legendLabels.push(round);
                }
            }
        }

        if(!normalizeData){
            maxValInt = 10 * Math.ceil(maxValInt / 10);
        }

        var radarConfig = {
            width: width,
            height: height,
            maxValue: maxValInt,
            levels: 5,
            ExtraWidthX: 300,
            normalize: normalizeData,
            legendLabels: legendLabels
        }
        
        RadarChart.draw("#chart", data, radarConfig);
    });
}

drawStarPlot();
